%% Sample Model Validation
%
%% Load sample data from MAT files
% Response with nominal model.
load('data_mdl_val_nom_q3.mat');
t_n = data_spd(:,1);
wl_n_m = data_spd(:,2);
wl_n_s = data_spd(:,3);
% Response with bumptest model.
load('data_mdl_val_bumptest_q3.mat');
t_b = data_spd(:,1);
wl_b_m = data_spd(:,2);
wl_b_s = data_spd(:,3);
%
%% Plot response
% Plot axis ranges
t_min = 0;
t_max = 0.5;
y_min = 0;
y_max = 40;
% Nominal plot
subplot(2,1,1)
plot(t_n,wl_n_m,'r-',t_n,wl_n_s,'b:');
ylabel('\omega_l (rad/s)')
title('\bf Nominal');
axis([t_min t_max y_min y_max]);
% Bumptest plot
subplot(2,1,2)
plot(t_b,wl_b_m,'r-',t_b,wl_b_s,'b:');
ylabel('\omega_l (rad/s)')
axis([t_min t_max y_min y_max]);
title('\bf Bumptest');
xlabel('time (s)');